<%
'**************************************
'* 最后更新 2012-11-26 by 56770.Kingdge
'* Copyright www.56770.com     
'**************************************
Class Cls_vbsPage
	Private oConn		'连接对象
	Private iPagesize	'每页记录数
	Private sPageName	'地址栏页数参数名
	Private sDbType
	'数据库类型,AC为access,MSSQL为SQL SERVER2000存储过程版,MYSQL为mysql,PGSQL为PostGreSql
	Private iRecType	'记录总数(>0为另外取值再赋予或者固定值,0执行count设置存cookies,-1执行count不设置cookies)
	Private sField		'字段名
	Private sTable		'表名
	Private sCondition	'条件,不需要where
	Private sOrderBy	'排序,不需要order by,需要asc或者desc
	Private sPkey		'主键,必写
	Private iRecCount

	'================================================================
	' Class_Initialize 类的初始化
	'================================================================
	Private Sub Class_Initialize
		iPageSize=10
		sPageName="Page"
		sDbType="AC"
		iRecType=0
		sField=" * "
	End Sub

	'================================================================
	' Conn 得到数据库连接对象
	'================================================================
	Public Property Set Conn(ByRef Value)
		Set oConn=Value
	End Property

	'================================================================
	' PageSize 设置每一页记录条数,默认10记录
	'================================================================
	Public Property Let PageSize(ByVal intPageSize)
		iPageSize=CheckNum(intPageSize,0,0,iPageSize,0) 
	End Property

	'================================================================
	' PageName 地址栏页数参数名
	'================================================================
	Public Property Let PageName(ByVal strPageName)
		sPageName=IIf(Len(strPageName)<1,sPageName,strPageName)
	End Property

	'================================================================
	' DbType 得到数据库类型
	'================================================================ 
	Public Property Let DbType(ByVal strDbType)
		sDbType=UCase(IIf(Len(strDbType)<1,sDbType,strDbType))
	End Property

	'================================================================
	' RecType 取记录总数(>0为赋值或者固定值,0执行count设置存cookies,-1执行count不设置cookies适用于搜索)
	'================================================================
	Public Property Let RecType(ByVal intRecType)
		iRecType=CheckNum(intRecType,0,0,iRecType,0) 
	End Property

	'================================================================
	' Pkey 取得主键
	'================================================================
	Public Property Let Pkey(ByVal strPkey)
		sPkey=strPkey
	End Property

	'================================================================
	' Field 取得字段名
	'================================================================
	Public Property Let Field(ByVal strField)
		sField=IIf(Len(strField)<1,sField,strField)
	End Property

	'================================================================
	' Table 取得表名
	'================================================================
	Public Property Let Table(ByVal strTable)
		sTable=strTable
	End Property

	'================================================================
	' Condition 取得条件
	'================================================================
	Public Property Let Condition(ByVal strCondition)
	    Dim s
		s=strCondition
		sCondition=IIf(Len(s)>2," WHERE "&s,"")
	End Property

	'================================================================
	' OrderBy 取得排序
	'================================================================
	Public Property Let OrderBy(ByVal strOrderBy)
	    Dim s
		s=strOrderBy
		sOrderBy=IIf(Len(s)>4," ORDER BY "&s,"")
	End Property

	'================================================================
	' RecCount 修正记录总数
	'================================================================
	Public Property Get RecCount()
	    Dim i,s
		If iRecType>0 Then
			i=iRecType
		Elseif iRecType=0 Then
			i=CheckNum(Request.Cookies("ShowoPage")(sPageName),1,0,0,0)
			s=Trim(Request.Cookies("ShowoPage")("sCond"))
			IF i=0 OR sCondition<>s Then
				i=oConn.Execute("SELECT COUNT("&sPkey&") FROM "&sTable&" "&sCondition,0,1)(0)
				If show_html = 0 Or InStr(LCase(Request.ServerVariables("URL")),"/category")>0 Then 
				        Response.Cookies("ShowoPage")(sPageName)=i
				        Response.Cookies("ShowoPage")("sCond")=sCondition
				        Response.Cookies("ShowoPage")("sRecCount")=i
				        i=request.Cookies("ShowoPage")("sRecCount")
				End If 
			End If
		Else
			i=oConn.Execute("SELECT COUNT("&sPkey&") FROM "&sTable&" "&sCondition,0,1)(0)
			If show_html = 0 Or InStr(LCase(Request.ServerVariables("URL")),"/category")>0 Then 
			        Response.Cookies("ShowoPage")("sRecCount")=i
			        i=request.Cookies("ShowoPage")("sRecCount")
			End If 
		End If
		iRecCount=i
		RecCount=i
	End Property

	'================================================================
	' ResultSet 返回分页后的记录集
	'================================================================
	Public Property Get ResultSet()
	    Dim s,i,iPageCount,iPageCurr,cm
		s=Null
		'记录总数
		i=iRecCount
		'当前页
		If i>0 Then
			iPageCount=Abs(Int(-Abs(i/iPageSize)))'页数
			If show_html = 0 Then 
			        iPageCurr=CheckNum(Request.QueryString(sPageName),1,1,1,iPageCount)'当前页
			Else 
			        iPageCurr=CheckNum(page,1,1,1,iPageCount)'当前页
			End If 
			Select Case sDbType
				Case "MSSQL" 'sqlserver2000数据库存储过程版
					Set Rs=server.CreateObject("Adodb.RecordSet")
					Set Cm=Server.CreateObject("Adodb.Command")
					Cm.CommandType=4
					Cm.ActiveConnection=oConn
					Cm.CommandText="sp_Util_Page"
					Cm.parameters(1)=i
					Cm.parameters(2)=iPageCurr
					Cm.parameters(3)=iPageSize
					Cm.parameters(4)=sPkey
					Cm.parameters(5)=sField
					Cm.parameters(6)=sTable
					Cm.parameters(7)=Replace(sCondition," WHERE ","")
					Cm.parameters(8)=Replace(sOrderBy," ORDER BY ","")
					Rs.CursorLocation=3
					Rs.LockType=1
					Rs.Open Cm
				Case "MYSQL" 'MYSQL数据库
					ResultSet_Sql="SELECT "&sField&" FROM "&sTable&" "&sCondition&" "&sOrderBy&" LIMIT "&(iPageCurr-1)*iPageSize&","&iPageSize
					Set Rs=oConn.Execute(ResultSet_Sql)
				Case Else '其他情况按最原始的方法处理(AC同理)
				    Dim rs,ResultSet_Sql
					Set Rs = Server.CreateObject ("Adodb.RecordSet")
					ResultSet_Sql="SELECT "&sField&" FROM "&sTable&" "&sCondition&" "&sOrderBy
					Rs.Open ResultSet_Sql,oConn,1,1,&H0001
					Rs.AbsolutePosition=(iPageCurr-1)*iPageSize+1
			End Select
			s=Rs.GetRows(iPageSize)
			Rs.close
			Set Rs=Nothing
		End If
		ResultSet=s
	End Property

	'================================================================
	' Class_Terminate 类注销
	'================================================================
	Private Sub Class_Terminate()
		'If IsObject(oConn) Then oConn.Close:Set oConn=Nothing
	End Sub

	'================================================================
	' 输入:检查字符,是否有最小值,是否有最大值,最小值(默认数字),最大值
	'================================================================
	Private Function CheckNum(ByVal strStr,ByVal blnMin,ByVal blnMax,ByVal intMin,ByVal intMax)
		Dim i,s,iMi,iMa
		s=Left(Trim(""&strStr),32):iMi=intMin:iMa=intMax
		If IsNumeric(s) Then
			i=CDbl(s)
			i=IIf(blnMin=1 And i<iMi,iMi,i)
			i=IIf(blnMax=1 And i>iMa,iMa,i)
		Else
			i=iMi
		End If
		CheckNum=i
	End Function

	'================================================================
	' 输入:简化条件判断
	'================================================================
	Private Function IIf(ByVal blnBool,ByVal strStr1,ByVal strStr2)
		Dim s
		If blnBool Then
			s=strStr1
		Else
			s=strStr2
		End If
		IIf=s
	End Function

	'================================================================
	' 上下页部分
	'================================================================
	Public Function ShowPageHead(Filename)
	    'On Error Resume Next 
	    Dim pagenmin,pagenmax,pagec,page_i,pagenc
		pagenmin=page-3'计算页码开始值
		If page = 1 Then 
		        pagenmax=page+5
        Else
		        pagenmax=page+5
		End If 
		If (pagenmin<1) then
			    pagenmin=1
		end If
		pagec = FormatNumber2(iRecCount/iPageSize)
		If pagec = ".00" Then pagec = 1
		If InStr(pagec,".") > 0 Then 
		        If CLng(Split(pagec,".")(1))>0 Then 
		        pagec = Split(pagec,".")(0) + 1
				Else
				pagec = CLng(Split(pagec,".")(0))
				End If 
		End If 
		if(pagenmax>pagec) then
		        pagenmax=pagec
		end If
		Dim strFile,RLoadStyle(6),firstpage,provpage,pagelist,looppagelist,nextpage,lastpage
		strFile = Eshop_url& Style_Folder &"Lebi.ShowPageHead."	
		If (page>1) Then
		        RLoadStyle(1) = LoadStyle(strFile&"1.style")
				firstpage = RLoadStyle(1)
				ReplaceStyle "firsturl",GetPageURL(Filename,1),firstpage
			    firstpage = splits(firstpage)
		Else
				firstpage = ""
		end if
		if(page>1 And CLng(page)<=CLng(pagec)) Then
		        RLoadStyle(2) = LoadStyle(strFile&"2.style")
				provpage = RLoadStyle(2)
				ReplaceStyle "provurl",GetPageURL(Filename,page-(pagenc*2+1)),provpage
			    provpage = splits(provpage)
		Else 
		        provpage = ""
		end If
		RLoadStyle(5) = LoadStyle(strFile&"5.style")
		RLoadStyle(6) = LoadStyle(strFile&"6.style")
		for page_i = pagenmin to pagenmax
	    	    If (CLng(page_i)=CLng(page)) Then
						pagelist = RLoadStyle(5)
						ReplaceStyle "pagenum",page_i,pagelist
						pagelist = splits(pagelist)
	    	    Else
						pagelist = RLoadStyle(6) 
						ReplaceStyle "pageurl",GetPageURL(Filename,page_i),pagelist
						ReplaceStyle "pagenum",page_i,pagelist
	    	    end If
				looppagelist = looppagelist & pagelist
		next
		If (CLng(page)<CLng(pagec)) Then
		        RLoadStyle(3) = LoadStyle(strFile&"3.style")
				nextpage = RLoadStyle(3)
				ReplaceStyle "nexturl",GetPageURL(Filename,page+(pagenc*2+1)),nextpage
			    nextpage = splits(nextpage)
		Else 
		        Nextpage = ""		
		end If
		If CLng(pagenmax) < CLng(pagec) Then 
		        RLoadStyle(4) = LoadStyle(strFile&"4.style")
				lastpage = RLoadStyle(4)
				ReplaceStyle "lasturl",GetPageURL(Filename,pagec),lastpage
			    lastpage = splits(lastpage)
		Else 
		        lastpage = ""
		End If 
		turnpage = page + 1
		If turnpage > pagenmax Then turnpage = pagenmax
		RLoadStyle(0) = splits(LoadStyle(strFile&"0.style"))
        ShowPageHead = RLoadStyle(0)
		ReplaceStyle "first",firstpage,ShowPageHead
		ReplaceStyle "prov",provpage,ShowPageHead
		ReplaceStyle "next",nextpage,ShowPageHead
		ReplaceStyle "last",lastpage,ShowPageHead
		ReplaceStyle "pagelist",looppagelist,ShowPageHead
		ReplaceStyle "page",page,ShowPageHead
		ReplaceStyle "turnpage",turnpage,ShowPageHead
		ReplaceStyle "totalpage",pagec,ShowPageHead
		ReplaceStyle "pagesize",iPageSize,ShowPageHead
		ReplaceStyle "datacount",iRecCount,ShowPageHead
		ReplaceStyle "pageurl",GetPageURL(Filename,0),ShowPageHead
	End Function 

	Public Function ShowPageFoot(Filename)
	    Dim pagenmin,pagenmax,pagec,page_i,pagenc
	    'On Error Resume Next 
		pagenmin=page-3'计算页码开始值
		If page = 1 Then 
		       pagenmax=page+5
        Else
		       pagenmax=page+3
		End If 
		If (pagenmin<1) then
			    pagenmin=1
		end If
		pagec = FormatNumber2(iRecCount/iPageSize)
		If pagec = ".00" Then pagec = 1
		If InStr(pagec,".") > 0 Then 
		        If CLng(Split(pagec,".")(1))>0 Then 
		        pagec = Split(pagec,".")(0) + 1
				Else
				pagec = CLng(Split(pagec,".")(0))
				End If 
		End If 
		if(pagenmax>pagec) then
		        pagenmax=pagec
		end If
		Dim strFile,RLoadStyle(6),firstpage,provpage,pagelist,looppagelist,nextpage,lastpage
		strFile = Eshop_url& Style_Folder &"Lebi.ShowPageFoot."	
		If (page>1) Then
		        RLoadStyle(1) = LoadStyle(strFile&"1.style")
				firstpage = RLoadStyle(1)
				ReplaceStyle "firsturl",GetPageURL(Filename,1),firstpage
			    firstpage = splits(firstpage)
		Else
				firstpage = ""
		end if
		if(page>1 And CLng(page)<=CLng(pagec)) Then
		        RLoadStyle(2) = LoadStyle(strFile&"2.style")
				provpage = RLoadStyle(2)
				ReplaceStyle "provurl",GetPageURL(Filename,page-(pagenc*2+1)),provpage
			    provpage = splits(provpage)
		Else 
		        provpage = ""
		end If
		RLoadStyle(5) = LoadStyle(strFile&"5.style")
		RLoadStyle(6) = LoadStyle(strFile&"6.style")
		for page_i = pagenmin to pagenmax
	    	    If (CLng(page_i)=CLng(page)) Then
						pagelist = RLoadStyle(5)
						ReplaceStyle "pagenum",page_i,pagelist
						pagelist = splits(pagelist)
	    	    Else
						pagelist = RLoadStyle(6) 
						ReplaceStyle "pageurl",GetPageURL(Filename,page_i),pagelist
						ReplaceStyle "pagenum",page_i,pagelist
	    	    end If
				looppagelist = looppagelist & pagelist
		next
		If (CLng(page)<CLng(pagec)) Then
		        RLoadStyle(3) = LoadStyle(strFile&"3.style")
				nextpage = RLoadStyle(3)
				ReplaceStyle "nexturl",GetPageURL(Filename,page+(pagenc*2+1)),nextpage
			    nextpage = splits(nextpage)
		Else 
		        Nextpage = ""		
		end If
		If CLng(pagenmax) < CLng(pagec) Then 
		        RLoadStyle(4) = LoadStyle(strFile&"4.style")
				lastpage = RLoadStyle(4)
				ReplaceStyle "lasturl",GetPageURL(Filename,pagec),lastpage
			    lastpage = splits(lastpage)
		Else 
		        lastpage = ""
		End If 
		turnpage = page + 1
		If turnpage > pagenmax Then turnpage = pagenmax
		RLoadStyle(0) = splits(LoadStyle(strFile&"0.style"))
        ShowPageFoot = RLoadStyle(0)
		ReplaceStyle "first",firstpage,ShowPageFoot
		ReplaceStyle "prov",provpage,ShowPageFoot
		ReplaceStyle "next",nextpage,ShowPageFoot
		ReplaceStyle "last",lastpage,ShowPageFoot
		ReplaceStyle "pagelist",looppagelist,ShowPageFoot
		ReplaceStyle "page",page,ShowPageFoot
		ReplaceStyle "turnpage",turnpage,ShowPageFoot
		ReplaceStyle "totalpage",pagec,ShowPageFoot
		ReplaceStyle "pagesize",iPageSize,ShowPageFoot
		ReplaceStyle "datacount",iRecCount,ShowPageFoot
		ReplaceStyle "pageurl",GetPageURL(Filename,0),ShowPageFoot
	End Function 

    Private Function GetPageURL(Filename,page)
        Dim strurl,str_url,i,j,search_str,result_url,str_params,PagePath
		If request.ServerVariables("SERVER_PORT") <> 80 Then 
				PagePath = "http://"&Request.ServerVariables("SERVER_NAME")&":"&request.ServerVariables("SERVER_PORT")
		Else
				PagePath = "http://"&Request.ServerVariables("SERVER_NAME")
		End If 
		If show_html = 1 And InStr(LCase(Request.ServerVariables("URL")),"tohtml")>0 Then 
		        result_url = PagePath & Filename&"."& page &"."& Sys_Ext
'		ElseIf ISAPI_Rewrite = 1 Then 
'		        result_url = PagePath & Filename&"_"& page &".html"
		Else 
				PagePath = PagePath & LCase(Request.ServerVariables("URL"))
				If ISAPI_Rewrite = 0 Then 
						PagePath = Replace(PagePath,"default.asp","")
						PagePath = Replace(PagePath,"index.asp","")
				End If 
				search_str="page="
                strurl=Request.ServerVariables("URL")
                Strurl=split(strurl,"/")
                i=UBound(strurl,1)
                str_url="" 'strurl(i)'得到当前页文件名
                str_params=Trim(Request.ServerVariables("QUERY_STRING"))
                If str_params="" Then
						Select Case page
							   Case "0" : result_url=str_url
							   Case Else
									result_url=str_url & "?page="& page
						End Select
                Else
                        If InstrRev(str_params,search_str)=0 Then
								Select Case page
									   Case "0" : result_url=str_url & "?" & str_params
									   Case Else
											result_url=str_url & "?" & str_params &"&page="& page
								End Select
                        Else
                                j=InstrRev(str_params,search_str)-2
								If j=-1 Then
										Select Case page
											   Case "0" : result_url=str_url
											   Case Else
													result_url=str_url & "?page="& page
										End Select
								Else
										str_params=Left(str_params,j)
										Select Case page
											   Case "0" : result_url=str_url & "?" & str_params
											   Case Else
													result_url=str_url & "?" & str_params &"&page="& page
										End Select
								End If
                        End If
                End If
				'result_url = PagePath & result_url
				If InStr(result_url,"value") >0 Or InStr(result_url,"brand") >0 Then 
						PagePath = Replace(PagePath,"default.asp","")
						PagePath = Replace(PagePath,"index.asp","")
						result_url = PagePath & result_url
				Else 
						result_url = ArchiveHtml(PagePath & result_url)
				End If 
		End If 
        GetPageURL=result_url
    End Function
	function formatnumber2(num)
			If IsNull(num) Or Not IsNumeric(num) Then
					Exit Function
			End If
			num = formatnumber(num,2)
			if num <1 And num > 0 then
					num= 0&num
					num = replace(num,"00.","0.")
			ElseIf num = 0 Then
					num= 0&num
			end if
			formatnumber2 = Replace(num,",","")
	end Function
End Class%>
